<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:java="http://xml.apache.org/xslt/java"
				extension-element-prefixes="java"
				version="1.0">

    <xsl:output indent="yes" method="xml" doctype-public="-//WAPFORUM//DTD WML 1.1//EN" doctype-system="http://www.wapforum.org/DTD/wml_1.1.xml" />

    <xsl:template match="AmlDocument">
        <xsl:element name="wml">                                            <!-- wml -->

		    <!-- <xsl:copy-of select="./@*"/> -->

		    <xsl:element name="head">                                       <!-- head -->
			
		        <xsl:element name="meta">                                   <!-- meta -->

				    <xsl:attribute name="http-equiv">
					    <xsl:value-of select="string('Cache-Control')"/>
				    </xsl:attribute>

				    <xsl:attribute name="content">
					    <xsl:value-of select="string('max-age=0')"/>
				    </xsl:attribute>

		        </xsl:element>                                              <!-- meta -->

		    </xsl:element>                                                  <!-- head -->


	        <xsl:apply-templates/>

        </xsl:element>                                                      <!-- wml -->
	
    </xsl:template>

<!-- this template needs to consider other checkbox aml attributes, ie italics -->
    <xsl:template match="AmlCheckBox">            <!-- AmlCheckBox -->
	    <xsl:element name="p">                    <!-- p -->
		    <xsl:attribute name="mode">
			    <xsl:value-of select="string('nowrap')"/>
			</xsl:attribute>
			<xsl:value-of select="./@text"/>
	        <xsl:element name="select">           <!-- select -->
		        <xsl:attribute name="name">
			        <xsl:value-of select="./@name"/>
		        </xsl:attribute>
		        <xsl:attribute name="ivalue">
			        <xsl:value-of select="string('2')"/>
		        </xsl:attribute>
			    <xsl:element name="option">        <!-- option -->
			        <xsl:attribute name="value">
			            <xsl:value-of select="string('yes')"/>
		            </xsl:attribute>
			        <xsl:value-of select="string('yes')"/>
	            </xsl:element>                     <!-- option -->
			    <xsl:element name="option">        <!-- option -->
			        <xsl:attribute name="value">
			            <xsl:value-of select="string('no')"/>
		            </xsl:attribute>
			        <xsl:value-of select="string('no')"/>
	            </xsl:element>                     <!-- option -->
	        </xsl:element>                         <!-- select --> 
	    </xsl:element>                             <!-- p -->
    </xsl:template>                                <!-- AmlCheckBox -->

	<xsl:template match="AmlChoice">               <!-- AmlChoice -->
	    <xsl:element name="p">
		    <xsl:attribute name="mode">
			    <xsl:value-of select="string('nowrap')"/>
		    </xsl:attribute>
            <xsl:value-of select="./@text"/>
			<xsl:element name="select">
		        <xsl:attribute name="name">
			        <xsl:value-of select="./@name"/>
		        </xsl:attribute>
			    <!-- <xsl:apply-templates/> -->
                <xsl:for-each select="./AmlOption">
			        <xsl:call-template name="force-option-content">
                        <xsl:with-param name="option-has-form-ancestor" select="boolean(ancestor::AmlForm)"/>
                        <xsl:with-param name="option-node" select="."/>
			        </xsl:call-template>
                </xsl:for-each>
	        </xsl:element>                         <!-- select -->
	    </xsl:element>                             <!-- p -->
    </xsl:template>                                <!-- AmlChoice -->


    <xsl:template name="force-option-content">
        <xsl:param name="option-has-form-ancestor"/>
        <xsl:param name="option-node"/>
	    <xsl:element name="option">
		    <xsl:attribute name="title">
	            <xsl:value-of select="string('Select')"/>
		    </xsl:attribute>
            <xsl:choose>
                <xsl:when test="$option-has-form-ancestor">
		            <xsl:attribute name="value">
			            <xsl:value-of select="$option-node/@value"/>
		            </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
		            <xsl:attribute name="onpick">
			            <xsl:value-of select="$option-node/@url"/>
		            </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
			<xsl:value-of select="string($option-node)"/>
	    </xsl:element>                            <!-- option -->
        <!-- don't apply-templates here, please. -->
    </xsl:template>

	<xsl:template match="AmlOption">               <!-- AmlOption -->
	    <xsl:element name="option">
		    <xsl:attribute name="title">
	            <xsl:value-of select="string('Select')"/>
		    </xsl:attribute>
            <xsl:choose>
                <xsl:when test="boolean(ancestor::AmlForm)">
		            <xsl:attribute name="value">
			            <xsl:value-of select="./@value"/>
		            </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
		            <xsl:attribute name="onpick">
			            <xsl:value-of select="./@url"/>
		            </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
			<!-- <xsl:value-of select="string(.)"/> -->
	    </xsl:element>
    </xsl:template>                                <!-- AmlOption -->

    <xsl:template match="AmlPage">
        <xsl:element name="card">                   <!-- card -->
		    <xsl:attribute name="newcontext">
			    <xsl:value-of select="string('true')"/>
		    </xsl:attribute>
		    <xsl:attribute name="title">
			    <xsl:value-of select="./@title"/>
		    </xsl:attribute>
		    <xsl:attribute name="id">
			    <xsl:value-of select="concat('c', count(.) - 1 )"/>
		    </xsl:attribute>
		    <!-- <xsl:copy-of select="./@*"/> -->
	        <xsl:apply-templates/>
        </xsl:element>                              <!-- card -->
    </xsl:template>

    <xsl:template match="AmlPCData">
        <xsl:element name="p">                      <!-- p -->
		<xsl:value-of select="./@text"/>
	        <xsl:apply-templates/>
        </xsl:element>                              <!-- p -->
    </xsl:template>
	
    <xsl:template match="AmlControlMenu">
        <xsl:element name="do">                     <!-- do -->

            <xsl:attribute name="label">
			    <xsl:value-of select="./@text"/>
            </xsl:attribute>

            <xsl:attribute name="type">
			    <xsl:value-of select="string('options')"/>
            </xsl:attribute>

            <xsl:attribute name="name">
			    <xsl:value-of select="./@text"/>
            </xsl:attribute>

            <xsl:element name="go">                <!-- go -->

                <xsl:attribute name="sendreferer">
			        <xsl:value-of select="string('true')"/>
                </xsl:attribute>

<!--
				<xsl:for-each select="./@*">
			        <xsl:value-of select="name(.)"/>
			        <xsl:value-of select="name()"/>
				</xsl:for-each>
-->

                <xsl:attribute name="href">
			        <xsl:value-of select="./@url"/>
                </xsl:attribute>

            </xsl:element>                         <!-- go -->

        </xsl:element>                              <!-- do -->

    </xsl:template>

    <xsl:template match="AmlTextArea">

	    <xsl:if test="not(./@view = 'hidden')">
            <xsl:element name="p">                      <!-- p -->
		        <xsl:value-of select="./@text"/>
                <xsl:element name="input">              <!-- input -->
                    <xsl:attribute name="name">
			            <xsl:value-of select="./@name"/>
                    </xsl:attribute>
					<xsl:if test="boolean(./@type)">
                        <xsl:attribute name="type">
			                <xsl:value-of select="./@type"/>
                        </xsl:attribute>
					</xsl:if>
                    <xsl:attribute name="value">
			            <xsl:value-of select="./@value"/>
                    </xsl:attribute>
                </xsl:element>                          <!-- input -->
            </xsl:element>                              <!-- p -->
	    </xsl:if>

    </xsl:template>

    <xsl:template match="AmlInput">

	    <xsl:if test="not(./@view = 'hidden')">
            <xsl:element name="p">                      <!-- p -->
		        <xsl:value-of select="./@text"/>
                <xsl:element name="input">              <!-- input -->
                    <xsl:attribute name="name">
			            <xsl:value-of select="./@name"/>
                    </xsl:attribute>
					<xsl:if test="boolean(./@type)">
                        <xsl:attribute name="type">
			                <xsl:value-of select="./@type"/>
                        </xsl:attribute>
					</xsl:if>
                    <xsl:attribute name="value">
			            <xsl:value-of select="./@value"/>
                    </xsl:attribute>
                </xsl:element>                          <!-- input -->
            </xsl:element>                              <!-- p -->
	    </xsl:if>

    </xsl:template>

    <xsl:template match="AmlForm">
        <xsl:apply-templates/>
        <xsl:element name="do">
            <xsl:attribute name="label">
                <xsl:value-of select="string('submit')"/>
            </xsl:attribute>
            <xsl:attribute name="type">
                <xsl:value-of select="string('accept')"/>
            </xsl:attribute>
            <xsl:element name="go">
                <xsl:attribute name="sendreferer">
                    <xsl:value-of select="string('true')"/>
                </xsl:attribute>
                <xsl:attribute name="href">
                    <xsl:value-of select="java:com.aligo.xslt.extension.xalan.nwml.getNextURL()"/>
                </xsl:attribute>
                <!-- nokia requires method="get", so: if (there is a method) then write it, else use 'get' -->
                <xsl:attribute name="method">
                    <xsl:choose>
                        <xsl:when test="boolean(./@method)">
                            <xsl:value-of select="./@method"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="string('get')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="AmlLink">
        <xsl:element name="p">                      <!-- p -->
            <xsl:element name="a">                  <!-- a -->
			    <xsl:attribute name="href">
				    <xsl:value-of select="./@url"/>
			    </xsl:attribute>
		                <xsl:value-of select="./@text"/>
            </xsl:element>                          <!-- a -->
        </xsl:element>                              <!-- p -->
    </xsl:template>

    <xsl:template match="AmlTable">
        <xsl:element name="p">                      <!-- p -->
            <xsl:element name="table">              <!-- table -->
		        <!-- <xsl:copy-of select="./@*"/> -->
                <xsl:attribute name="columns">
                    <xsl:value-of select="./@columns"/>
                </xsl:attribute>
                <xsl:apply-templates/>
            </xsl:element>                          <!-- table -->
        </xsl:element>                              <!-- p -->
    </xsl:template>

    <xsl:template match="AmlTableRow">
        <xsl:element name="tr">                     <!-- tr -->
		    <xsl:copy-of select="./@*"/>
            <xsl:apply-templates/>
        </xsl:element>                              <!-- tr -->
    </xsl:template>

    <xsl:template match="AmlTableCol">
        <xsl:element name="td">                     <!-- td -->
		    <!-- 
                 <xsl:copy-of select="./@*"/>
                 <xsl:apply-templates/>
            -->
            <xsl:apply-templates select="./@text"/>
        </xsl:element>                              <!-- td -->
    </xsl:template>

    <xsl:template match="AmlTableHead">
        <xsl:element name="td">                     <!-- td -->
            <xsl:element name="b">                  <!-- b -->
                <xsl:apply-templates select="./@text"/>
            </xsl:element>                          <!-- b -->
        </xsl:element>                              <!-- td -->
    </xsl:template>

</xsl:stylesheet>
