<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:xalan="http://xml.apache.org/xslt"
  version="1.0">

<xsl:output method="html" indent="yes" xalan:indent-amount="4"/> 



<xsl:strip-space elements="*"/>
    <xsl:variable name="new-line" select="'&#xA;'"/>
    <xsl:variable name="amper"    select="'&amp;'"/>
    <xsl:variable name="nbspace"  select="'&#xA0;'"/>
    <xsl:template match="/">

        <xsl:element name="html">

            <xsl:element name="head">

                <meta name="PalmComputingPlatform" content="true"/>

                <xsl:element name="title">
                    <xsl:value-of select="AmlDocument/@title"/>
                </xsl:element>

            </xsl:element>                      <!-- head -->

            <xsl:element name="body">
            
                <xsl:element name="h1">
                    <xsl:value-of select="AmlDocument/@title"/>
                </xsl:element>
                
                <!-- recurse throughout remainder of document templates -->
                <xsl:apply-templates/>
                
            </xsl:element>                      <!-- body -->

        </xsl:element>                          <!-- html -->

    </xsl:template>                             <!-- match="/" -->

    <xsl:template match="AmlPCData">
        <xsl:element name="p">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>                             <!-- AmlPCData -->

    <xsl:template match="AmlTable">
        <xsl:element name="table">
            <xsl:copy-of select="./@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>                             <!-- AmlTable -->

    <xsl:template match="AmlTableRow">
        <xsl:element name="tr">
            <xsl:copy-of select="./@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>                             <!-- AmlTableRow -->

    <xsl:template match="AmlTableCol">
        <xsl:element name="td">
            <xsl:copy-of select="./@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>                             <!-- AmlTableCol -->


    <xsl:template match="AmlTableHead">
        <xsl:element name="th">
            <xsl:copy-of select="./@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>                             <!-- AmlTableHead -->


    <xsl:template match="AmlLink">
        <xsl:element name="a">
            <xsl:attribute name="href">
              	<xsl:value-of select="./@url" />
            </xsl:attribute>
            <xsl:value-of select="./@text"/> 
        </xsl:element>
    </xsl:template>                             <!-- AmlLink -->

<!-- needs work re: hidden and other atts -->
    <xsl:template match="AmlForm">
        <xsl:element name="form">
        
            <xsl:attribute name="action">
              	<xsl:value-of select="./@url" />
            </xsl:attribute>
        
            <xsl:attribute name="method">
              	<xsl:value-of select="./@method" />
            </xsl:attribute> 
<!--            <xsl:copy-of select="./@*"/> -->
            <xsl:apply-templates/>

            <xsl:element name="p">

                <xsl:element name="input">
                    <xsl:attribute name="name">
                      	<xsl:value-of select="'request'" />
                    </xsl:attribute> 
                    <xsl:attribute name="type">
                      	<xsl:value-of select="'submit'" />
                    </xsl:attribute> 
                    <xsl:attribute name="value">
                      	<xsl:value-of select="'Submit'" />
                    </xsl:attribute> 
                </xsl:element>                  <!-- submit -->

                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>

                <xsl:element name="input">
                    <xsl:attribute name="name">
                      	<xsl:value-of select="'clear'" />
                    </xsl:attribute> 
                    <xsl:attribute name="type">
                      	<xsl:value-of select="'reset'" />
                    </xsl:attribute> 
                    <xsl:attribute name="value">
                      	<xsl:value-of select="'Clear'" />
                    </xsl:attribute> 
                </xsl:element>                  <!-- clear -->


            </xsl:element>                      <!-- p -->

        </xsl:element>                          <!-- form -->
    </xsl:template>                             <!-- AmlForm -->

    <xsl:template match="AmlInput">
        <xsl:element name="div">
            <xsl:value-of select="./@text"/> 
              <xsl:element name="input">
				<xsl:choose>
			      <xsl:when test="./@view='hidden'">
				        <xsl:attribute name="name">
					        <xsl:value-of select="./@name"/>
				        </xsl:attribute>
				        <xsl:attribute name="value">
					        <xsl:value-of select="./@value"/>
				        </xsl:attribute>
				        <xsl:attribute name="type">
					        <xsl:value-of select="./@view"/>
				        </xsl:attribute>
			      </xsl:when>
			      <xsl:otherwise>
                        <xsl:copy-of select="./@*"/> 
			      </xsl:otherwise>
				</xsl:choose>
              </xsl:element>
        </xsl:element>
    </xsl:template>                             <!-- AmlInput -->

    <xsl:template match="AmlPage">
        <xsl:element name="a"  use-attribute-sets="local-target-attrib-set">
        </xsl:element>
        <xsl:apply-templates/>        
    </xsl:template> <!-- AmlPage -->

    <xsl:attribute-set name="local-target-attrib-set">
        <xsl:attribute name="ID"><xsl:value-of select="string('target')"/></xsl:attribute>
        <xsl:attribute name="NAME"><xsl:value-of select="string(generate-id(.))"/></xsl:attribute>
    </xsl:attribute-set>
    


    <xsl:template match="AmlControlMenu">
        <xsl:element name="a">
            <xsl:attribute name="href">
              	 <xsl:value-of select="./@url"/>   
            </xsl:attribute>
            <!-- steve keep? <xsl:apply-templates/>    -->
            <xsl:value-of select="./@text"/> 
        </xsl:element>                          <!-- a -->

        <xsl:if test="position()!=last()">
       		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        </xsl:if>
        <xsl:if test="position()=last()">
        	<xsl:element name="p" />
        </xsl:if>

    </xsl:template>                             <!-- AmlControlMenu -->
    


    <xsl:template match="AmlTextArea">
        <xsl:element name="p" >
            <xsl:value-of select="./@text"/> 
	        <xsl:element name="textarea" >
			<xsl:copy-of select="./@*"/>                   
	        </xsl:element>                          <!-- textarea -->
	        <xsl:value-of select="$nbspace"/>
	</xsl:element>                             	<!-- p -->
	</xsl:template>                             	<!-- AmlTextArea -->
    
    <xsl:template match="AmlCheckBox">
        <xsl:value-of select="./@text"/> 
<!--	<xsl:apply-templates/> -->
	<xsl:element name="input">
	    <xsl:attribute name="type">
	      	<xsl:value-of select="'checkbox'" />
	    </xsl:attribute> 
		<xsl:copy-of select="./@*"/>                   
	</xsl:element>
    </xsl:template>                             <!-- AmlCheckBox -->

    <xsl:template match="AmlChoice">
          <xsl:choose>
            <xsl:when test="boolean(ancestor::AmlForm)">
                <xsl:value-of select="./@text"/>
            	<xsl:element name="select">
                    <xsl:choose>
                        <xsl:when test="boolean(./@name)">
        		    <xsl:attribute name="name">
	              		<xsl:value-of select="./@name" />
	            	    </xsl:attribute>
                        </xsl:when>
                    </xsl:choose>
            	    <xsl:apply-templates/>
            	</xsl:element>			<!-- select -->
            </xsl:when>
            <xsl:otherwise>
	        <xsl:element name="p">
            	    <xsl:apply-templates/>
	        </xsl:element>                  <!-- p -->
            </xsl:otherwise>
          </xsl:choose>
    </xsl:template>                             <!-- AmlChoice -->
    

    <xsl:template match="AmlOption">
      <xsl:choose>
            <xsl:when test="boolean(ancestor::AmlForm)">
	        <xsl:element name="option">
	            <xsl:attribute name="value">
	              	<xsl:value-of select="./@value" />
	            </xsl:attribute>
	          <!-- <xsl:apply-templates/> -->
	          <xsl:value-of select="./@text" />
	        </xsl:element>
        </xsl:when>
        <xsl:otherwise>
	        <xsl:element name="a">
	            <xsl:attribute name="href">
	              	<xsl:value-of select="./@url" />
	            </xsl:attribute>
	    		
                    <xsl:value-of select="./@text"/> 
	           <!--  <xsl:apply-templates/> -->
	        </xsl:element> 				<!-- a -->
                <!-- netscape issue - <BR/> not rendered as expected, so... -->
	        <!-- <xsl:element name="br"> -->
                <xsl:text disable-output-escaping="yes">&lt;BR&gt;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>

    </xsl:template>                             <!-- AmlOption -->

</xsl:stylesheet>
