<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="aligo-chtml.xsl" />
<xsl:output method="html" indent="yes"/>

  <xsl:template match="AmlDocument">

        <xsl:element name="html">

            <xsl:element name="head">
                <!-- start CSS for this action -->
                <xsl:element name="style">
                    <xsl:attribute name="type">
                        <xsl:value-of select="string('text/css')" />
                    </xsl:attribute>
                    <xsl:text disable-output-escaping="yes">
                        body { background-color:F5F5F5; font-family: arial,sans-serif; }
                    </xsl:text>
                </xsl:element>
                <!-- end CSS for this action -->

                <xsl:element name="script">
                    <xsl:attribute name="language">
                        <xsl:value-of select="string('JavaScript1.2')" />
                    </xsl:attribute>
                    <xsl:text disable-output-escaping="yes">
<![CDATA[
/*
 * ticker.js, by angus@netscape.com
 * No formal support offered. 
 */


function swapTicker(ref) {
/*
 This function is called to swap the "clone" tape with the "real" tape.
 It is called whenever the active tape is about to run out.
 See docs for more info on this concept.
*/

 if (ref.activeTicker == ref.tickLayer) {
  ref.activeTicker = ref.tickLayerSub;
  ref.nonActiveTicker = ref.tickLayer;
  return true;
 }
 ref.activeTicker=ref.tickLayer;
 ref.nonActiveTicker=ref.tickLayerSub;
 return true;
}

function slideTick(ref,inc) {
/*
 This function is called using setInterval. It slides the ticker ever so
 slightly in each iteration. It performs checks to see if it should be 
 swapping the tape, and it also performs checks to make sure that it has
 the "backup" tape on the correct side of the "active" tape, in case the
 user switches gears by sliding the tape in the opposite direction.
*/
 ref.tickLayer.moveBy(inc,0);
 ref.tickLayerSub.moveBy(inc,0);

 if ((ref.activeTicker.left < (ref.realWidth*-1)) && (ref.velocity<0)) {
  ref.activeTicker.moveBy(ref.realWidth*2,0);
  swapTicker(ref);
 }
 if ((ref.activeTicker.left > ref.width) && (ref.velocity>0)) {
  ref.activeTicker.moveBy(ref.realWidth*-2,0);
  swapTicker(ref);
 }
 if ((ref.velocity>0)&&(ref.activeTicker.left>0) && 
	(ref.nonActiveTicker.left > (ref.activeTicker.left-ref.realWidth))) {
 		ref.nonActiveTicker.moveTo(ref.activeTicker.left-ref.realWidth,0);
	}
if ((ref.velocity<0)&&(ref.activeTicker.left<(0-ref.realWidth+ref.width)) && 
	(ref.nonActiveTicker.left < (ref.activeTicker.left+ref.realWidth))) {
 		ref.nonActiveTicker.moveTo(ref.activeTicker.left+ref.realWidth,0);
	}
}

function startTicker() {
/*
 this is the Ticker.start() method. It checks to make sure the user hasn't placed
 the ticker into stop mode before starting (because this is called from mouseover
 events also). It then optimizes the interval time difference and the movement per
 iteration to work out so that slideTicker is called every 15 or more seconds (this
 is to avoid really short timeout periods). It then fires off an interval to start
 the motion.
*/

 ref = this;
 if (!ref.velocity) ref=this.parent;
 if (!ref.onLoadFired) {
	if (ref.onLoad) ref.onLoad();
	ref.onLoadFired = true;
	} 
 if (ref.active) ref.stop();
 if (ref.stopped == true) return(false);
 var increment = 1000/Math.abs(ref.velocity);
 var amount = ref.velocity/Math.abs(ref.velocity);
 while (increment < 15) {
  amount *=2;
  increment *=2;
 }
 ref.active = setInterval(slideTick,increment,ref,amount);
 return(true);
}

function stopTicker() {
clearInterval(this.active);
}

function slowVelocity(e) {
/*
 Called whenever the mouse goes over the ticker tape. Stops the ticker,
 reduces velocity to 50%, and restarts the ticker. Only does this if the
 ticker motion is currently active. (Ticker.active is the interval ID)
 Routes off the event if its happening over an anchor.
*/

 if (e.target.constructor == window.Url) return routeEvent(e);
 if (this.parent.active) {
 this.parent.stop();
 this.parent.velocity *= .5;
 this.parent.start();
 return true;
}
}

function speedVelocity(e) {
/*
 Called whenever the mouse goes out of the ticker tape. Stops the ticker,
 increases velocity back up to 100%, and restarts the ticker. Only does this if the
 ticker motion is currently active. (Ticker.active is the interval ID)
 Routes off the event if its happening over an anchor.
*/


 if (e.target.constructor == window.Url) return routeEvent(e);
 if (this.parent.active) {
 this.parent.stop();
 this.parent.velocity *= 2;
 this.parent.start();
 return true;
}
}

function makeSubTicker() {
/*
 Called in the Ticker constructor phase, this creates the initial "clone"
 tape by instantiating a new layer.
*/

 ref = this.parent;
 ref.tickLayerSub = new Layer(ref.realWidth,ref.container);
 if (ref.velocity < 0) ref.tickLayerSub.left=ref.realWidth;
 if (ref.velocity > 0) ref.tickLayerSub.left=ref.realWidth*-1;
 ref.tickLayerSub.top=0;
 ref.tickLayerSub.clip.width = ref.realWidth;
 ref.tickLayerSub.clip.height = ref.height;
 ref.tickLayerSub.visibility="inherit";
 ref.tickLayerSub.src=ref.src;
 ref.tickLayerSub.onMouseOver = slowVelocity;
 ref.tickLayerSub.onMouseOut = speedVelocity;
 ref.tickLayerSub.parent = ref;
 ref.nonActiveTicker = ref.tickLayerSub;
 ref.tickLayerSub.onLoad=ref.start;
}

function makeTicker(ref) {
/*
 Called in the Ticker constructor phase, this creates the initial "active"
 tape by instantiating a new layer.
*/

 ref.tickLayer = new Layer(ref.realWidth,ref.container);
 ref.tickLayer.left=0;
 ref.tickLayer.top=0;
 ref.tickLayer.clip.width = ref.realWidth;
 ref.tickLayer.clip.height = ref.height;
 ref.tickLayer.visibility="inherit";
 ref.tickLayer.src=ref.src;
 ref.activeTicker = ref.tickLayer;
 ref.tickLayer.onLoad=makeSubTicker;
 ref.tickLayer.onMouseOver = slowVelocity;
 ref.tickLayer.onMouseOut = speedVelocity;
 ref.tickLayer.parent = ref;
}

function drag(e) {
/*
 Called when a drag is in process. Moves the ticker vertically and slides
 it horizontally. Wont allow vertical repositioning if the verticalLock is on.
 also makes sure that you don't vertically reposition the ticker outside the 
 window. It also checks to see if it needs to reposition the clone tape relative
 to the active tape.
*/
   if (!this.parent.parent.verticalLock) this.parent.moveBy(0,e.pageY-oldY);
   this.layers[0].moveBy(e.pageX-oldX,0);
   this.layers[1].moveBy(e.pageX-oldX,0);
   if (this.parent.top < 0) this.parent.moveTo(this.parent.left,0);
   if (this.parent.top > window.innerHeight-this.parent.clip.height) this.parent.moveTo(this.parent.left, window.innerHeight-this.parent.clip.height);

 if ((this.parent.left>0)&&(this.parent.parent.activeTicker.left>0) && 
	(this.parent.parent.nonActiveTicker.left > (this.parent.parent.activeTicker.left-this.parent.parent.realWidth))) {
 		this.parent.parent.nonActiveTicker.moveTo(this.parent.parent.activeTicker.left-this.parent.parent.realWidth,0);
	}
 if ((this.parent.parent.activeTicker.left<0)&&(this.parent.parent.activeTicker.left+this.parent.parent.activeTicker.clip.width<(this.parent.parent.width))) {
 		this.parent.parent.nonActiveTicker.moveTo(this.parent.parent.activeTicker.left+this.parent.parent.realWidth,0);
	}

   oldX = e.pageX;
   oldY = e.pageY;
}

function beginDrag(e) {
/*
 Called when a drag event first happens. Routes off any events occuring to
 a link. Grabs the current time to use later for velocity calculation. 
 Begins trapping mousemove events. Initializes the drag vars.
*/
  
   if (e.target.constructor == window.Url) return routeEvent(e);
   startDragTime = new Date();
   this.parent.parent.stop();
   this.captureEvents(Event.MOUSEMOVE);
   this.onmousemove=drag; 
   oldX=e.pageX;
   oldY=e.pageY;
   startX=e.pageX;
   startY=e.pageY;
   return false;
}

function drop(e) {
/*
 Called when a drag event ends and the ticker is dropped. Routes off any
 events occuring to a link. Grabs the current time, and uses the elapsed
 time of the drag in conjunction with the distance of the drag to determine
 average velocity in pixels per second. It makes sure velocity lock is not
 on before applying the new velocity. When applying, it divides the 
 velocity by 4, because the mouseover event has put velocity to 50% already,
 and also because people drag things too darn fast. If event happens to the 
 right mouse button (3) it doesn't start the ticker again, because the
 right mouse button is the "stop" button.
*/

 if (e.target.constructor == window.Url) return routeEvent(e);
 endDragTime = new Date();
 dragDuration = (endDragTime.getTime() - startDragTime.getTime())/1000;
 dragDistance = e.pageX - startX;

 if (dragDistance > -2 && dragDistance < 2) {
     this.releaseEvents(Event.MOUSEMOVE);
     if (e.which == 1) {
		this.parent.parent.stopped = false;
		this.parent.parent.start();
		}
     if (e.which == 3) this.parent.parent.stopped = true;
     return false;
     }

 dragAverageVelocity = dragDistance/dragDuration;
 this.onmousemove=0; 
 this.releaseEvents(Event.MOUSEMOVE);

   if (!this.parent.parent.velocityLock) this.parent.parent.velocity = Math.round(dragAverageVelocity/4);
   else {
	 if (this.parent.parent.velocity<0 && dragAverageVelocity>0) this.parent.parent.velocity *= -1;
	 if (this.parent.parent.velocity>0 && dragAverageVelocity<0) this.parent.parent.velocity *= -1;
   	 }

   if ((this.parent.parent.velocityMinimum) && 
	Math.abs(this.parent.parent.velocity) < this.parent.parent.velocityMinimum) {
         if (this.parent.parent.velocity < 0) this.parent.parent.velocity = -1*(this.parent.parent.velocityMinimum/2);
         if (this.parent.parent.velocity > 0) this.parent.parent.velocity = (this.parent.parent.velocityMinimum/2);
         }

   if ((this.parent.parent.velocityMaximum) &&
	Math.abs(this.parent.parent.velocity) > this.parent.parent.velocityMaximum) {
         if (this.parent.parent.velocity < 0) this.parent.parent.velocity = -1*(this.parent.parent.velocityMaximum/2);
         if (this.parent.parent.velocity > 0) this.parent.parent.velocity = (this.parent.parent.velocityMaximum/2);
         }
   if (e.which == 1) {
	this.parent.parent.stopped = false;
	this.parent.parent.start();
	}
   if (e.which == 3) this.parent.parent.stopped = true;
   return false;
}

function Ticker(left,top,width,height,src,realwidth,velocity) {
/*
 Object stuff. Creates references to all the necessary properties and
 methods, creates the container layer and then calls the functions to
 create the active tape, the clone tape, which in turn calls the 
 start() method here when everything has loaded sequentially. Sets initial
 values to some vars. 
*/

 this.src = src;
 this.left = eval(left);
 this.top = eval(top);
 this.width = eval(width);
 this.height = eval(height);
 this.realWidth= eval(realwidth);
 this.velocity = eval(velocity);
 this.verticalLock = false;
 this.velocityLock = false;
 this.velocityMinimum = null;
 this.velocityMaximum = null;
 this.onLoadFired = false;
 this.onLoad = null;
 this.start = startTicker;
 this.stop = stopTicker;
 this.stopped = false;
 this.container = new Layer(width)
 this.container.left = eval(left);
 this.container.top = eval(top);
 this.container.clip.width= eval(width);
 this.container.clip.height= eval(height);
 this.container.visibility = "show";
 this.container.parent = this;
 this.container.onLoad = makeTicker(this);
 this.container.document.parent = this.container;
 this.container.document.captureEvents(Event.MOUSEDOWN | Event.MOUSEUP);
 this.container.document.onmousedown=beginDrag;
 this.container.document.onmouseup=drop;
}
]]></xsl:text>

                </xsl:element>
                <xsl:element name="script">
                    <xsl:attribute name="language">
                        <xsl:value-of select="string('JavaScript')" />
                    </xsl:attribute>
                    <xsl:text disable-output-escaping="yes"><![CDATA[
function init() {
if ( parseInt(navigator.appVersion.substring(0,1)) >= 4
    && navigator.appName.substring(0,8).toLowerCase() == "netscape")
     // arguments are: left,top,width,height,src,realwidth,velocity
     myTicker = new Ticker(50,100,500,20,"http://10.1.1.25/content.html",1000,-150);
    }
}]]></xsl:text>
                </xsl:element>

                <meta name="PalmComputingPlatform" content="true"/>

                <xsl:element name="title">
                    <xsl:value-of select="AmlDocument/@title"/>
                </xsl:element>

            </xsl:element>                      <!-- head -->

            <xsl:element name="body">
                <xsl:attribute name="onload">
                    <xsl:value-of select="string('init()')"/>
                </xsl:attribute>
            
                <xsl:element name="h1">
                    <xsl:value-of select="AmlDocument/@title"/>
                </xsl:element>
                
                <!-- recurse throughout remainder of document templates -->
                <xsl:apply-templates/>
                
            </xsl:element>                      <!-- body -->

        </xsl:element>                          <!-- html -->


  </xsl:template>                             <!-- AmlDocument -->

  <!-- overriding this template.  The AligoEngine wraps hrefs in the AmlLink element.
       To make AmlLink behave without the p element... comment out this template. --> 
  <xsl:template match="AmlLink">
      <xsl:element name="p">
          <xsl:element name="a">
              <xsl:attribute name="href">
                  <xsl:value-of select="./@url" />
              </xsl:attribute>
              <xsl:apply-templates/>
            </xsl:element>                          <!-- a -->
      </xsl:element>                              <!-- p -->
  </xsl:template>                             <!-- AmlLink -->

</xsl:stylesheet>
