<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:xalan="http://xml.apache.org/xslt"
  xmlns:java="http://xml.apache.org/xslt/java"
  extension-element-prefixes="java"
  version="1.0">

<xsl:output method="xml" indent="no" xalan:indent-amount="4"/> 
<xsl:strip-space elements="*"/>

    <xsl:template match="AmlDocument">
        <xsl:element name="AmlDocument">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlDocument" -->
     
    <xsl:template match="AmlPage">
        <xsl:element name="AmlPage">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlPage" -->
    
    <xsl:template match="AmlChoice">
        <xsl:element name="AmlChoice">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlChoice" -->

    <xsl:template match="AmlTable">
        <xsl:element name="AmlTable">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlTable" -->

    <xsl:template match="AmlTableRow">
        <xsl:element name="AmlTableRow">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlTableRow" -->

    <xsl:template match="AmlTableHead">
        <xsl:element name="AmlTableHead">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlTableHead" -->

    <xsl:template match="AmlTableCol">
        <xsl:element name="AmlTableCol">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlTableCol" -->


    <xsl:template match="AmlPCData">
        <xsl:element name="AmlPCData">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlPCData" -->

    <xsl:template match="AmlOption">
        <xsl:element name="AmlOption">
           <xsl:apply-templates select="./AmlURL"/>
           <xsl:attribute name="text">
               <xsl:value-of select="string(./@text)"/> 
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test="boolean(./@url)">
                <xsl:attribute name="url">
                   <xsl:value-of select="string(./@url)"/> 
              </xsl:attribute>
             </xsl:when>
           </xsl:choose>
           <xsl:value-of select="string(.)"/> 
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlOption" -->

    <xsl:template match="AmlControlMenu">
        <xsl:element name="AmlControlMenu">
           <xsl:apply-templates select="./AmlURL"/>
           <xsl:attribute name="text">
               <xsl:value-of select="string(./@text)"/> 
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test="boolean(./@url)">
                <xsl:attribute name="url">
                   <xsl:value-of select="string(./@url)"/> 
              </xsl:attribute>
             </xsl:when>
           </xsl:choose>
           <xsl:value-of select="string(.)"/> 
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlControlMenu" -->

    <xsl:template match="AmlForm">
        <xsl:element name="AmlForm">
           <xsl:apply-templates select="./AmlURL"/>
           <xsl:attribute name="text">
               <xsl:value-of select="string(./@text)"/> 
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test="boolean(./@url)">
                <xsl:attribute name="url">
                   <xsl:value-of select="string(./@url)"/> 
              </xsl:attribute>
             </xsl:when>
           </xsl:choose>
           <xsl:value-of select="string(.)"/> 
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlForm" -->

    <xsl:template match="AmlInput">
        <xsl:element name="AmlInput">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlInput" -->

    <xsl:template match="AmlTextArea">
        <xsl:element name="AmlTextArea">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlTextArea" -->

    <xsl:template match="AmlCheckBox">
        <xsl:element name="AmlCheckBox">
           <xsl:copy-of select="./@*" />
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlCheckBox" -->

    <xsl:template match="AmlLink">
        <xsl:element name="AmlLink">
           <xsl:apply-templates select="./AmlURL"/>
           <xsl:attribute name="text">
               <xsl:value-of select="string(./@text)"/> 
           </xsl:attribute>
           <xsl:choose>
             <xsl:when test="boolean(./@url)">
                <xsl:attribute name="url">
                   <xsl:value-of select="string(./@url)"/> 
              </xsl:attribute>
             </xsl:when>
           </xsl:choose>
           <xsl:value-of select="string(.)"/> 
           <xsl:apply-templates />
        </xsl:element>
    </xsl:template>                             <!-- match="AmlLink" -->

    <xsl:template match="AmlURL">
       <xsl:attribute name="url">
           <xsl:value-of select="java:com.aligo.xslt.extension.xalan.AML_PUBLIC_PRIVATE.constructExternalURL()"/> 
       </xsl:attribute>
    </xsl:template>                             <!-- match="AmlURL" -->

<xsl:template match="M1" />

</xsl:stylesheet>
