/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/

/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.aml.*;
import com.aligo.exceptions.*;
import com.aligo.servlet.*;
import com.aligo.ums.messages.*;
import com.aligo.ums.provider.*;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

import com.xyz.wireless.AligoProjectConstants;

import com.aligo.logging.AligoLog;


public class SmsSend extends AligoProjectAction {

    String phoneNum_;    //phone
    String message_;     //message

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        //these should only come from the request
        phoneNum_ = parseParamString("phonenum", request, true, FROM_REQUEST,
                                     false);
        message_  = parseParamString("message", request, true, FROM_REQUEST,
                                     false);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        AmlDocument amlDoc = new AmlDocument();

        try {
            amlDoc.setTitle("Restaurant Guide, Powered by M-1 Server");

            AmlPage amlPage = new AmlPage();

            amlPage.setTitle("");

            //CONTROL MENU
            AmlControlMenu nextControlMenu = new AmlControlMenu();

            nextControlMenu.setText("Back");

            AmlURL amlURL = new AmlURL("SelectRestaurants");

            addSession(amlURL);
            nextControlMenu.setURL(amlURL);
            amlPage.addAmlControlMenu(nextControlMenu);

            //CONTROL MENU
            ShortMessage sm = new ShortMessage(message_, phoneNum_,
                                               phoneNum_);

            sm.send();
            amlPage.setTitle("SMS Sent!");

            AmlPCData messageText = new AmlPCData();

            messageText
                .setText("Thanks! Your message was sent successfully. ");
            amlPage.addAmlPCData(messageText);

            //create the choice and add the options
            AmlChoice amlChoice = new AmlChoice();

            //option 
            AmlOption amlOption = new AmlOption();

            amlOption.setText("Start over");

            AmlURL url1 = new AmlURL("EnterName");

            amlOption.setURL(url1);
            amlChoice.addAmlOption(amlOption);
            amlPage.addAmlChoice(amlChoice);
            amlDoc.addAmlPage(amlPage);
        } catch (AligoException aTextNoCanDo) {
            AligoLog.log(this.getClass().getName(),
                         " AligoException: " + aTextNoCanDo.getMessage(),
                         ERROR_SEVERITY);

            // If there was a problem we create an error document based on
            // the exception
            amlDoc = createErrorDocument(aTextNoCanDo);
        }

        return amlDoc;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
