/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.aml.*;
import com.aligo.exceptions.*;
import com.aligo.servlet.*;
import com.aligo.ums.messages.*;
import com.aligo.ums.provider.*;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

import com.xyz.wireless.AligoProjectConstants;
import com.xyz.wireless.data.*;
import com.xyz.wireless.container.*;

import com.aligo.logging.AligoLog;


public class SendFax extends AligoProjectAction {

    String fax_;
    String userName_;
    String restaurantChosen_;

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        fax_              = parseParamString("faxNum", request, true,
                                             FROM_REQUEST, false);
        userName_         = parseParamString("UserName", request, true,
                                             FROM_REQUEST_SESSION, false);
        restaurantChosen_ = parseParamString("restId", request, true,
                                             FROM_REQUEST_SESSION, false);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        AmlDocument amldoc = new AmlDocument();

        try {
            Address     address;
            Direction[] directions;
            int         restId = new Integer(restaurantChosen_).intValue();

            try {
                address    =
                    AligoAccessor.getDataService().getAddressByRestId(restId);
                directions =
                    AligoAccessor.getDataService()
                        .getDirectionsByRestId(restId);
            } catch (AligoAccessException aAe) {
                AligoLog.log(this.getClass().getName() + aAe.getMessage());

                return createErrorDocument(aAe);
            }

            Restaurant rest = (Restaurant) sessionHash.get("rest");

            amldoc.setTitle("Witness the power of M-1");

            AmlPage amlpage = new AmlPage();

            amlpage.setTitle("");

            //CONTROL MENU
            AmlControlMenu nextControlMenu = new AmlControlMenu();

            nextControlMenu.setText("Back");

            AmlURL amlURL = new AmlURL("SelectRestaurants");

            addSession(amlURL);
            nextControlMenu.setURL(amlURL);
            amlpage.addAmlControlMenu(nextControlMenu);

            //CONTROL MENU
            //Build the fax message text
            StringBuffer body = new StringBuffer();

            body.append("Here are the driving directions sent to you by ");
            body.append(userName_);
            body.append(".\n\n");
            body.append("From:\n");
            body.append("2201 E. Camelback Road\n");
            body.append("Phoenix, AZ 85016\n\n");
            body.append("To:\n");
            body.append(rest.getRestName());
            body.append("\n");
            body.append(address.getPrintableAddress());
            body.append("\n\n");
            body.append(printDirections(directions));
            body.append("\n----------------\n");

            Fax fax = new Fax(fax_, body.toString());

            fax.send();

            AmlPCData messageText = new AmlPCData();

            messageText.setText("Thanks! Your Fax was Sent. ");
            amlpage.addAmlPCData(messageText);

            //create the choice and add the options
            AmlChoice amlChoice = new AmlChoice();

            //option 
            AmlOption amlOption = new AmlOption();

            amlOption.setText("Start over");

            AmlURL url1 = new AmlURL("EnterName");

            amlOption.setURL(url1);
            amlChoice.addAmlOption(amlOption);
            amlpage.addAmlChoice(amlChoice);
            amldoc.addAmlPage(amlpage);
        } catch (AligoException ae) {
            amldoc = createErrorDocument(ae);
        }

        return amldoc;
    }

    private String printDirections(Direction[] dirs) {

        StringBuffer retVal = new StringBuffer();

        for (int i = 0; i < dirs.length - 1; i++) {
            retVal.append(dirs[i].getStepId() + ": ");
            retVal.append(dirs[i].getStepText());
            retVal.append("\n");
        }

        retVal.append(dirs[dirs.length - 1].getStepText());

        return retVal.toString();
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
