/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.aml.*;
import com.aligo.exceptions.*;
import com.aligo.servlet.*;
import com.aligo.logging.*;

import com.xyz.wireless.data.*;
import com.xyz.wireless.container.*;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

import com.xyz.wireless.AligoProjectConstants;


public class SelectRestaurants extends AligoProjectAction {

    String userName_;
    int    restTypeId_;

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        userName_   = parseParamString("UserName", request, true,
                                       FROM_SESSION, false);
        restTypeId_ = parseParamInt("FoodType", request, true,
                                    FROM_REQUEST_SESSION, true);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        // Access the back office
        Restaurant[] restList;

        try {
            restList =
                AligoAccessor.getDataService()
                    .getRestaurantsByRestTypeId(restTypeId_);
        } catch (AligoAccessException aAe) {
            ErrorLog.log(this.getClass().getName() + aAe.getMessage(), aAe);

            return createErrorDocument(aAe);
        }

        AmlDocument amlDoc = new AmlDocument();

        try {
            amlDoc.setTitle("Restaurant Guide, Powered by M-1 Server");

            AmlPage amlPage = new AmlPage();

            //amlPage.setTitle("");
            AmlPCData amlPCData = new AmlPCData();

            //CONTROL MENU
            AmlControlMenu nextControlMenu = new AmlControlMenu();

            nextControlMenu.setText("Back");

            AmlURL amlURL = new AmlURL("FavoriteFood");

            nextControlMenu.setURL(amlURL);
            amlPage.addAmlControlMenu(nextControlMenu);

            //CONTROL MENU
            if ((restList == null) || (restList.length == 0)) {
                amlPCData.setText(userName_ + ", pick:");
                amlPage.addAmlPCData(amlPCData);
            } else {
                amlPCData.setText(userName_ + ", pick:");
                amlPage.addAmlPCData(amlPCData);

                AmlTable amlTable = new AmlTable();

                amlTable.setColumns(3);
                amlTable.setMaxColWidth(10);

                AmlTableRow  aRow = new AmlTableRow();
                AmlTableHead head = new AmlTableHead();

                head.setText("Restaurant");
                head.setBold(true);
                aRow.addAmlTableHead(head);

                head = new AmlTableHead();

                head.setText("Cost");
                head.setBold(true);
                aRow.addAmlTableHead(head);

                head = new AmlTableHead();

                head.setText("Phone");
                head.setBold(true);
                aRow.addAmlTableHead(head);
                amlTable.addAmlTableRow(aRow);

                AmlTableCol aCol;

                for (int i = 0; i < restList.length; i++) {
                    aRow = new AmlTableRow();
                    aCol = new AmlTableCol();

                    aCol.setText(restList[i].getRestName());
                    aRow.addAmlTableCol(aCol);

                    aCol = new AmlTableCol();

                    aCol.setText(restList[i].getRestCost());
                    aRow.addAmlTableCol(aCol);

                    aCol = new AmlTableCol();

                    AmlLink link1 = new AmlLink();

                    link1.setText(restList[i].getRestPhone());

                    AmlURL url1 = new AmlURL("ProcessRestSelection");

                    url1.addParam("restId", restList[i].getRestId());
                    link1.setURL(url1);
                    aCol.addAmlLink(link1);
                    aRow.addAmlTableCol(aCol);
                    amlTable.addAmlTableRow(aRow);
                }

                amlPage.addAmlTable(amlTable);
            }

            amlDoc.addAmlPage(amlPage);
        } catch (AligoException aTextNoCanDo) {
            ErrorLog.log(this.getClass().getName() + " AligoException:  "
                         + aTextNoCanDo.getMessage());

            amlDoc = createErrorDocument(aTextNoCanDo);
        }

        return amlDoc;
    }    //execute
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
