/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.exceptions.*;
import com.aligo.aml.*;
import com.aligo.servlet.*;
import com.aligo.ums.messages.*;
import com.aligo.ums.provider.*;
import com.aligo.logging.AligoLog;

import com.xyz.wireless.data.*;
import com.xyz.wireless.container.*;
import com.xyz.wireless.AligoProjectConstants;


public class ProcessRestSelection extends AligoProjectAction {

    String restaurantChosen_;

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        //this is the value selected in the SelectRestaurants action table but i'm checking if it's
        //in the session in case they jump around the pages
        restaurantChosen_ = parseParamString("restId", request, true,
                                             FROM_REQUEST_SESSION, false);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        Restaurant rest   = null;
        int        restId = new Integer(restaurantChosen_).intValue();

        try {
            rest = AligoAccessor.getDataService()
                .getRestaurantByRestId(restId);
        } catch (AligoAccessException aAe) {
            AligoLog.log(this.getClass().getName() + aAe.getMessage());

            return createErrorDocument(aAe);
        }

        AmlDocument amlDoc = new AmlDocument();

        try {
            amlDoc.setTitle("Restaurant Guide, Powered by M-1 Server");

            AmlPage amlPage = new AmlPage();

            amlPage.setTitle("Your Choice");
            sessionHash.put("restId", restaurantChosen_);
            sessionHash.put("rest", rest);

            //CONTROL MENU
            AmlControlMenu amlcontrolmenu = new AmlControlMenu();

            amlcontrolmenu.setText("Send an SMS");

            AmlURL amlURL = new AmlURL("InviteFriend");

            addSession(amlURL);
            amlcontrolmenu.setURL(amlURL);
            amlPage.addAmlControlMenu(amlcontrolmenu);

            //CONTROL MENU
            //CONTROL MENU
            amlcontrolmenu = new AmlControlMenu();

            amlcontrolmenu.setText("Email Directions");

            amlURL = new AmlURL("EmailDirections");

            addSession(amlURL);
            amlcontrolmenu.setURL(amlURL);
            amlPage.addAmlControlMenu(amlcontrolmenu);

            //CONTROL MENU
            //CONTROL MENU
            amlcontrolmenu = new AmlControlMenu();

            amlcontrolmenu.setText("Fax Directions");

            amlURL = new AmlURL("FaxDirections");

            addSession(amlURL);
            amlcontrolmenu.setURL(amlURL);
            amlPage.addAmlControlMenu(amlcontrolmenu);

            //CONTROL MENU
            AmlPCData    text = new AmlPCData();
            StringBuffer sb   = new StringBuffer();

            sb.append("You chose ");
            sb.append(rest.getRestName());
            sb.append(". What would you like to do next? ");
            text.setText(sb.toString());
            amlPage.addAmlPCData(text);
            amlDoc.addAmlPage(amlPage);
        } catch (AligoException aTextNoCanDo) {
            AligoLog.log(this.getClass().getName(),
                         " AligoException:  " + aTextNoCanDo.getMessage(),
                         ERROR_SEVERITY);

            // If there was a problem we create an error document based on the exception
            amlDoc = createErrorDocument(aTextNoCanDo);
        }

        return amlDoc;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
