/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.aml.*;
import com.aligo.exceptions.*;
import com.aligo.servlet.*;
import com.aligo.ums.messages.*;
import com.aligo.ums.provider.*;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

import com.xyz.wireless.AligoProjectConstants;
import com.xyz.wireless.container.*;

import com.aligo.logging.AligoLog;


public class InviteFriend extends AligoProjectAction {

    String userName_;
    String restaurantChosen_;

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        userName_         = parseParamString("UserName", request, true,
                                             FROM_REQUEST_SESSION, false);
        restaurantChosen_ = parseParamString("restId", request, true,
                                             FROM_REQUEST_SESSION, false);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        AmlDocument amldoc = new AmlDocument();

        try {
            amldoc.setTitle("Restaurant Guide, Powered by M-1 Server");

            Restaurant rest    = (Restaurant) sessionHash.get("rest");
            AmlPage    amlPage = new AmlPage();

            amlPage.setTitle("");
            amlPage.setId("AdminMenu");
            amldoc.addAmlPage(amlPage);

            AmlPCData amlPCData = new AmlPCData();

            amlPCData.setText(
                "Send an SMS to a friend. You can change the message.");
            amlPCData.setBold(true);
            amlPage.addAmlPCData(amlPCData);

            AmlForm amlForm = new AmlForm();

            addSession(amlForm);

            AmlURL amlUrl = new AmlURL("SmsSend");

            addSession(amlUrl);
            amlForm.setURL(amlUrl);

            StringBuffer body = new StringBuffer();

            body.append("Come meet me at ");
            body.append(rest.getRestName());
            body.append(" tonight at 7pm.");
            body.append(" Thanks! ");
            body.append(userName_);

            AmlInput amlInput1 = new AmlInput();

            amlInput1.setName("phonenum");
            amlInput1.setText("Enter mobile phone number:");
            amlForm.addAmlInput(amlInput1);

            AmlTextArea amlInput2 = new AmlTextArea();

            amlInput2.setName("message");
            amlInput2.setText("Enter your message:");
            amlInput2.setValue(body.toString());
            amlForm.addAmlTextArea(amlInput2);
            amlPage.addAmlForm(amlForm);
        } catch (AligoException ae) {
            amldoc = createErrorDocument(ae);
        }

        return amldoc;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
