/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.myAction;



import java.io.*;

import java.util.*;

import javax.servlet.http.*;

import com.aligo.util.*;
import com.aligo.aml.*;
import com.aligo.exceptions.*;
import com.aligo.servlet.*;
import com.aligo.logging.*;

import com.xyz.wireless.data.*;
import com.xyz.wireless.container.*;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

import com.xyz.wireless.AligoProjectConstants;


public class FavoriteFood extends AligoProjectAction {

    String userName_;

    public boolean validateInput(HttpServletRequest request) {

        boolean retVal = true;

        userName_ = parseParamString("UserName", request, true,
                                     FROM_REQUEST_SESSION, true);

        return retVal;
    }

    public AmlDocument execute(
            HttpServletResponse response, HttpServletRequest request)
                throws IOException {

        Lookup[] restTypeList;

        try {
            restTypeList =
                AligoAccessor.getDataService().getRestaurantTypes();
        } catch (AligoAccessException aAe) {
            ErrorLog.log(this.getClass().getName() + aAe.getMessage(), aAe);

            return createErrorDocument(aAe);
        }

        AmlDocument amlDoc = new AmlDocument();

        try {
            amlDoc.setTitle("Restaurant Guide, Powered by M-1 Server");

            AmlPage amlPage = new AmlPage();

            amlPage.setTitle("");

            AmlForm amlForm = new AmlForm();
            AmlURL  amlUrl  = new AmlURL("SelectRestaurants");

            amlForm.setURL(amlUrl);

            AmlChoice amlChoice = new AmlChoice();

            amlChoice.setText(userName_ + ", pick cuisine: ");
            amlChoice.setAudioText(
                userName_
                + ", please listen to the following cuisine selections and choose your favorite at any time");
            amlChoice.setName("FoodType");

            for (int i = 0; i < restTypeList.length; i++) {
                AmlOption amlOption = new AmlOption();

                amlOption.setValue(restTypeList[i].getIndex() + "");
                amlOption.setText(restTypeList[i].getValue());
                amlOption.setAudioPreSelectText("To choose "
                                                + restTypeList[i].getValue()
                                                + "cuisine, push" + i + 1);
                amlChoice.addAmlOption(amlOption);
            }

            amlForm.addAmlChoice(amlChoice);
            amlPage.addAmlForm(amlForm);
            amlDoc.addAmlPage(amlPage);
        } catch (AligoException aTextNoCanDo) {
            ErrorLog.log(this.getClass().getName() + " AligoException:  "
                         + aTextNoCanDo.getMessage());

            amlDoc = createErrorDocument(aTextNoCanDo);
        }

        return amlDoc;
    }    //execute
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
