/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/

//package com.xyz.wireless.myapp.data;
package com.xyz.wireless.data;



import java.io.*;

import java.sql.*;

import java.lang.*;

import java.util.*;

import java.math.*;

import com.aligo.db.*;
import com.aligo.logging.*;
import com.aligo.util.*;
import com.aligo.exceptions.*;

import com.xyz.wireless.*;
import com.xyz.wireless.container.*;

import net.ejip.aligo.db.EjipDBConnector;
/**
 *  connector class, provides a connection to the database...
 *  @note   uh, was AligoDAL (data access layer)
 */
public class AligoConnector extends EjipDBConnector {

    public AligoConnector() throws SQLException, ClassNotFoundException {
        super();
    }

    /**
     * This returns the list of restaurants of a specified type
     *
     * DBAccess Methods which use:
     * <UL>
     *      <LI>TBD</LI>
     * </UL>
     *
     * @return Restaurant[]
     *
     * @param int - The rest_type_id to be queried
     * @throws SQLException
     * @see com.aligo.example.bidask.data.DBAccess.TBD
     */
    public Restaurant[] getRestaurantsByRestTypeId(int restTypeId)
            throws SQLException {

        Restaurant tempRest;
        Vector     resultVector = new Vector();
        Statement  Stat         = super.conn.createStatement();
        String     sqlText      = "SELECT " + "  r.rest_name, "
                                  + "  r.rest_type_id, " + "  r.rest_cost, "
                                  + "  r.rest_phone, " + "  rt.rest_type, "
                                  + "  r.rest_id "
                                  + "FROM restaurant r, rest_type rt "
                                  + "WHERE r.rest_type_id = rt.rest_type_id "
                                  + "AND rt.rest_type_id = " + restTypeId;

        // Lets Log what we have
        DebugLog.log(getClass().getName() + ".getRestaurantsByType() SQL: "
                     + sqlText);

        try {
            ResultSet RS = Stat.executeQuery(sqlText);

            while (RS.next()) {
                tempRest = new Restaurant();

                tempRest.setRestName(RS.getString("rest_name"));
                tempRest.setRestTypeId(RS.getInt("rest_type_id"));
                tempRest.setRestCost(RS.getString("rest_cost"));
                tempRest.setRestPhone(RS.getString("rest_phone"));
                tempRest.setRestType(RS.getString("rest_type"));
                tempRest.setRestId(RS.getInt("rest_id"));
                resultVector.add(tempRest);
            }
        } catch (SQLException sqlE) {
            ErrorLog.log("SQLException in  getRestaurantsByType "
                         + sqlE.getMessage());

            throw (sqlE);
        } finally {
            Stat.close();
        }

        // Lets cast that Vector to a Restaurant  array
        Restaurant[] returnVal = new Restaurant[resultVector.size()];

        for (int i = 0; i < resultVector.size(); i++) {
            returnVal[i] = (Restaurant) resultVector.elementAt(i);
        }

        return returnVal;
    }

    public Restaurant getRestaurantByRestId(int restId) throws SQLException {

        Restaurant rest    = null;
        Statement  Stat    = super.conn.createStatement();
        String     sqlText = "SELECT " + "  r.rest_name, "
                             + "  r.rest_type_id, " + "  r.rest_cost, "
                             + "  r.rest_phone, " + "  rt.rest_type, "
                             + "  r.rest_id "
                             + "FROM restaurant r, rest_type rt "
                             + "WHERE r.rest_type_id = rt.rest_type_id "
                             + "AND r.rest_id = " + restId;

        // Lets Log what we have
        DebugLog.log(getClass().getName() + ".getRestaurantByRestId() SQL: "
                     + sqlText);

        try {
            ResultSet RS = Stat.executeQuery(sqlText);

            while (RS.next()) {
                rest = new Restaurant();

                rest.setRestName(RS.getString("rest_name"));
                rest.setRestTypeId(RS.getInt("rest_type_id"));
                rest.setRestCost(RS.getString("rest_cost"));
                rest.setRestPhone(RS.getString("rest_phone"));
                rest.setRestType(RS.getString("rest_type"));
                rest.setRestId(RS.getInt("rest_id"));
            }
        } catch (SQLException sqlE) {
            ErrorLog.log("SQLException in  getRestaurantByRestId "
                         + sqlE.getMessage());

            throw (sqlE);
        } finally {
            Stat.close();
        }

        return rest;
    }

    public Direction[] getDirectionsByRestId(int restId) throws SQLException {

        Direction tempDir;
        Vector    resultVector = new Vector();
        Statement Stat         = super.conn.createStatement();
        String    sqlText      =
            "select rest_id, step_id, step_text from directions where rest_id="
            + restId + " order by step_id";

        // Lets Log what we have
        DebugLog.log(getClass().getName() + ".getDirectionsByRestId() SQL: "
                     + sqlText);

        try {
            ResultSet RS = Stat.executeQuery(sqlText);

            while (RS.next()) {
                tempDir = new Direction();

                tempDir.setRestId(RS.getInt("rest_id"));
                tempDir.setStepId(RS.getInt("step_id"));
                tempDir.setStepText(RS.getString("step_text"));
                resultVector.add(tempDir);
            }
        } catch (SQLException sqlE) {
            ErrorLog.log("SQLException in  getDirectionsByRestId "
                         + sqlE.getMessage());

            throw (sqlE);
        } finally {
            Stat.close();
        }

        // Lets cast that Vector to a Direction  array
        Direction[] returnVal = new Direction[resultVector.size()];

        for (int i = 0; i < resultVector.size(); i++) {
            returnVal[i] = (Direction) resultVector.elementAt(i);
        }

        return returnVal;
    }

    public Address getAddressByRestId(int restId) throws SQLException {

        Address   returnAddr = null;
        Statement Stat       = super.conn.createStatement();
        String    sqlText    =
            "select rest_id, street_address, city, state, zip from address where rest_id = "+restId;

        // Lets Log what we have
        DebugLog.log(getClass().getName() + ".getAddressByRestId() SQL: "
                     + sqlText);

        try {
            ResultSet RS = Stat.executeQuery(sqlText);

            while (RS.next()) {
                returnAddr = new Address();

                returnAddr.setRestId(RS.getInt("rest_id"));
                returnAddr.setStreetAddress(RS.getString("street_address"));
                returnAddr.setCity(RS.getString("city"));
                returnAddr.setState(RS.getString("state"));
                returnAddr.setZip(RS.getString("zip"));
            }
        } catch (SQLException sqlE) {
        	sqlE.printStackTrace();
            ErrorLog.log("SQLException in  getAddressByRestId "
                         + sqlE.getMessage());

            throw (sqlE);
        } finally {
            Stat.close();
        }

        return returnAddr;
    }

    public Lookup[] getRestaurantTypes() throws SQLException {

        Lookup    tempId;
        Vector    resultVector = new Vector();
        Statement Stat         = super.conn.createStatement();
        String    sqlText      = "SELECT " + "  rest_type_id, "
                                 + "  rest_type " + " FROM rest_type ";

        // Lets Log what we have
        DebugLog.log(getClass().getName() + ".getRestaurantTypes() SQL: "
                     + sqlText);

        try {
            ResultSet RS = Stat.executeQuery(sqlText);

            while (RS.next()) {
                tempId = new Lookup();

                tempId.setIndex(RS.getInt("rest_type_id"));
                tempId.setValue(RS.getString("rest_type"));
                resultVector.add(tempId);
            }
        } catch (SQLException sqlE) {
            ErrorLog.log("SQLException in  getRestaurantTypes "
                         + sqlE.getMessage());

            throw (sqlE);
        } finally {
            Stat.close();
        }

        // Lets cast that Vector to a Lookup  array
        Lookup[] returnVal = new Lookup[resultVector.size()];

        for (int i = 0; i < resultVector.size(); i++) {
            returnVal[i] = (Lookup) resultVector.elementAt(i);
        }

        return returnVal;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
