/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.data;



import java.io.*;

import java.sql.*;

import java.util.*;

import com.xyz.wireless.*;
import com.xyz.wireless.container.*;

import com.aligo.db.*;
import com.aligo.util.*;
import com.aligo.exceptions.*;
import com.aligo.extensions.*;
import com.aligo.logging.*;

//Ejip.Net required classes for DB connection management
import net.ejip.aligo.db.*;

///import com.aligo.project.base.*;   // for accessor base class

/**
 *  data accessor object, provides the database service and biz-logic...
 *  @note   uh, in the old architecture, this was DBAccess
 */
public class AligoAccessor extends EjipDBAccessor {

    // Constructor takes care of initiating all database connections.
    public AligoAccessor() {
        super();
    }

    // singleton instance
    private static AligoAccessor singleton = new AligoAccessor();
    private static String        connector = "com.xyz.wireless.data.AligoConnector";

	// Ejip.Net required modification.  This overrides the dbPool attribute in the 
	// com.aligo.db.DBAccessor ancestor, yet prevents any further code changes in
	// this class.
	private EjipDBConnectionManager dbPool = new EjipDBConnectionManager("com.xyz.wireless.data.AligoConnector");
	
    /**
     * Returns unique instance of singleton object.
     * @return DBAccess singleton object
     */
    synchronized public static AligoAccessor getDataService() {
        return singleton;
    }

    /**
     *  initialization of the singleton and logic object...
     */
    synchronized public static void init() throws AligoExtensionException {

        singleton = new AligoAccessor();

        try {
            singleton.startup(connector);
        } catch (AligoException aae) {
            throw new AligoExtensionException(aae.getMessage());
        }
    }

    /* ----- logic methods to work with database -------------------- */
    public Restaurant[] getRestaurantsByRestTypeId(int restTypeId)
            throws AligoAccessException {

        Restaurant[]   retVal;
        AligoConnector conn = (AligoConnector) dbPool.fetch();

        try {
            retVal = conn.getRestaurantsByRestTypeId(restTypeId);
        } catch (SQLException e) {
            ErrorLog
                .log("Problems in AligoAccessor.getRestaurantByRestTypeId "
                     + e.getMessage());

            throw new AligoAccessException(e.toString(), e.getErrorCode());
        } finally {
            dbPool.recycle(conn);
        }

        return retVal;
    }

    public Direction[] getDirectionsByRestId(int restId)
            throws AligoAccessException {

        Direction[]    retVal;
        AligoConnector conn = (AligoConnector) dbPool.fetch();

        try {
            retVal = conn.getDirectionsByRestId(restId);
        } catch (SQLException e) {
            ErrorLog.log("Problems in AligoAccessor.getDirectionsByRestId "
                         + e.getMessage());

            throw new AligoAccessException(e.toString(), e.getErrorCode());
        } finally {
            dbPool.recycle(conn);
        }

        return retVal;
    }

    public Address getAddressByRestId(int restId)
            throws AligoAccessException {

        Address        retVal;
        AligoConnector conn = (AligoConnector) dbPool.fetch();

        try {
            retVal = conn.getAddressByRestId(restId);
        } catch (SQLException e) {
            ErrorLog.log("Problems in AligoAccessor.getAddressByRestId "
                         + e.getMessage());

            throw new AligoAccessException(e.toString(), e.getErrorCode());
        } finally {
            dbPool.recycle(conn);
        }

        return retVal;
    }

    public Restaurant getRestaurantByRestId(int restId)
            throws AligoAccessException {

        Restaurant     retVal;
        AligoConnector conn = (AligoConnector) dbPool.fetch();

        try {
            retVal = conn.getRestaurantByRestId(restId);
        } catch (SQLException e) {
            ErrorLog.log("Problems in AligoAccessor.getRestaurantByRestId "
                         + e.getMessage());

            throw new AligoAccessException(e.toString(), e.getErrorCode());
        } finally {
            dbPool.recycle(conn);
        }

        return retVal;
    }

    public Lookup[] getRestaurantTypes() throws AligoAccessException {

        Lookup[]       retVal;
        AligoConnector conn = (AligoConnector) dbPool.fetch();

        try {
            retVal = conn.getRestaurantTypes();
        } catch (SQLException e) {
            ErrorLog.log("Problems in AligoAccessor.getRestaurantTypes "
                         + e.getMessage());

            throw new AligoAccessException(e.toString(), e.getErrorCode());
        } finally {
            dbPool.recycle(conn);
        }

        return retVal;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
