/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless.container;



/**
 *  data model object for a restaurant...
 */
public class Address extends Object {

    // CREATE TABLE address ( rest_id int PRIMARY KEY NOT NULL, street_address char(50), city char(30), state char(2), zip char(10))
    // attributes...
    private String streetAddress;
    private String city;
    private String state;
    private String zip;
    private int    restId;

    /**
     *  default constructor: creates new Restaurant
     */
    public Address() {

        streetAddress = "";
        city          = "";
        state         = "";
        zip           = "";
        restId        = -1;
    }

    /**
     *  uninteresting stuff: accessors & mutators...
     */
    public String getStreetAddress() {
        return streetAddress;
    }

    public void setStreetAddress(String a) {
        streetAddress = a;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String c) {
        city = c;
    }

    public String getState() {
        return state;
    }

    public void setState(String st) {
        state = st;
    }

    public String getZip() {
        return zip;
    }

    public void setZip(String z) {
        zip = z;
    }

    public int getRestId() {
        return restId;
    }

    public void setRestId(int id) {
        restId = id;
    }

    public String getPrintableAddress() {

        String printable = getStreetAddress() + "\n" + getCity() + ","
                           + getState() + " " + getZip() + "\n";

        return printable;
    }
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
