/****************************************************
 *                                                  *
 * Copyright 2001 Aligo, Inc.  All Rights Reserved. *
 *                                                  *
 ****************************************************/
package com.xyz.wireless;



/**
 * <H2>Summary:</H2>
 * Constants used to keep all message text content centrally located.
 * Changes to the protocol can be made here once and affect the entire
 * package.
 * @author
 * @see
 * @see
 */
public class AligoProjectConstants {

    // utility...
    public static final String PROP_FILE = "prop_file_restex";
    public static final String DEVICE_ID = "deviceId";
    public static final String SQL_TRUE  = "1";
    public static final String SQL_FALSE = "0";

    // field definitions...
    public static final String FLD_ACTION_ID = "aId";
    public static final String FLD_USER_ID   = "uId";
    public static final String FLD_PASSWORD  = "password";
    public static final String FLD_USER_NAME = "username";
    public static final String FLD_SERVER    = "server";
    public static final String FLD_DOMAIN    = "domain";
    public static final String FLD_NAME      = "Restaurant";
    public static final String FLD_PHONE     = "Phone";
    public static final String FLD_COST      = "Cost";
    public static final String FLD_ADD_NAME  = "Name";
    public static final String FLD_ADD_PHONE = "Phone";
    public static final String FLD_ADD_COST  = "Cost";

    // request parameters...
    public static final String REQ_EDIT_ID = "eid";

    // field type definitions...
    public static final String F_TYPE_TEXT     = "text";
    public static final String F_TYPE_PASSWORD = "password";

    // parameter definitions...
    public static final String ARG_USER_ID   = "uid";
    public static final String ARG_USER_NAME = "username";
    public static final String ARG_PASSWORD  = "password";

    // url definitions...
    public static final String URL_LOGON  = "Logon";
    public static final String URL_LOGOUT = "Logout";
    public static final String URL_MENU   = "RestaurantMenu";
    public static final String URL_LIST   = "ViewRestaurants";
    public static final String URL_ADD    = "AddRestaurant";
    public static final String URL_EDIT   = "EditRestaurant";
    public static final String URL_DELETE = "DeleteRestaurant";

    // logging definitions...
    public static final int DEBUG   = 0;
    public static final int INFO    = 1;
    public static final int WARNING = 2;
    public static final int ERROR   = 3;

    // other...
    public static final int NO_CURRENT = -1;
}


/*--- Formatted in Sun Java Convention Style on Tue, Aug 21, '01 ---*/


/*------ Formatted by Jindent 3.23 Basic 1.0 --- http://www.jindent.de ------*/
