-- The following is DDL for Restaurant Guide.  If first starting out,
-- cut-and-paste everything from the CREATE TABLE rest_type on down
-- into the Ejip.Net Console's Database Manager and click Execute SQL
-- button to run the SQL commands
-- This SQL is for PostgreSQL database.

DROP TABLE restaurant;
DROP TABLE rest_type;
DROP TABLE address;
DROP TABLE directions;

CREATE TABLE rest_type (
  rest_type_id INT NOT NULL PRIMARY KEY,
  rest_type VARCHAR(20)
);

CREATE TABLE restaurant (
  rest_id INT NOT NULL,
  rest_name VARCHAR(20),
  rest_type_id INT NOT NULL,
  rest_cost VARCHAR(8),
  rest_phone VARCHAR(12),
CONSTRAINT "PK_rest_id" PRIMARY KEY ("rest_id"),
CONSTRAINT "FK_rest_type_id" FOREIGN KEY ("rest_type_id") REFERENCES rest_type ("rest_type_id")
);


INSERT INTO rest_type (rest_type_id, rest_type) VALUES (1, 'Indian');
INSERT INTO rest_type (rest_type_id, rest_type) VALUES (2, 'Chinese');
INSERT INTO rest_type (rest_type_id, rest_type) VALUES (3, 'Italian');

INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (1, 'Gaylords', 1, '$$$', '602-555-1234');
INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (2, 'Taj Majal', 1, '$$$', '408-555-1234');
INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (3, 'Masala Mudiam', 1, '$$', '480-555-1234');

INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (4, 'FireCracker', 2, '$$', '415-555-1234');
INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (5, 'HaHa China', 2, '$$', '480-555-1234');
INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (6, 'PF Changs', 2, '$$', '602-555-1234');

INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (7, 'House of Capone', 3, '$$', '602-555-1234');

INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (8, 'DeSalle Kitchen', 3, '$$$', '303-555-1234');

INSERT INTO  restaurant (rest_id, rest_name, rest_type_id, rest_cost, rest_phone)
VALUES (9, 'Noto Diner', 3, '$', '480-555-1234');

CREATE TABLE address ( rest_id int PRIMARY KEY NOT NULL, street_address char(50), city char(30), state char(2), zip char(10));
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 1, '2135 E Camelback RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 2, '2621 E Camelback RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 3, '2728 E Thomas RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 4, '2710 E Indian School RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 5, '4626 N 16TH ST', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 6, '2135 E Camelback RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 7, '2621 E Camelback RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 8, '2728 E Thomas RD', 'Phoenix', 'AZ', '85016');
INSERT INTO  address (rest_id, street_address, city, state, zip) values ( 9, '2710 E Indian School RD', 'Phoenix', 'AZ', '85016');

CREATE TABLE directions ( rest_id int NOT NULL, 
	step_id int, 
	step_text char(100),
CONSTRAINT "pk_directions" PRIMARY KEY (rest_id, step_id) 
);


INSERT INTO  directions (rest_id, step_id, step_text) values ( 1, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 1, 2, 'Turn LEFT onto E CAMELBACK RD.   0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 1, 3, 'Total Distance:   0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 2, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 2, 2, 'Turn RIGHT onto E CAMELBACK RD.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 2, 3, 'Total Distance:  0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 3, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 3, 2, 'Turn RIGHT onto E CAMELBACK RD.   0.4 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 3, 3, 'Turn RIGHT onto N 24TH ST.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 3, 4, 'Turn LEFT onto E THOMAS RD.   0.4 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 3, 5, 'Total Distance:  1.3 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 4, 1, 'Start out going South on N 22ND ST towards E HIGHLAND AVE by turning left.  1.0 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 4, 2, 'Turn LEFT onto E INDIAN SCHOOL RD.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 4, 3, 'Total Distance:  1.6 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 5, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 5, 2, 'Turn LEFT onto E CAMELBACK RD.   0.7 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 5, 3, 'Turn LEFT onto N 16TH ST.   0.3 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 5, 4, 'Total Distance:  1.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 6, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 6, 2, 'Turn LEFT onto E CAMELBACK RD.   0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 6, 3, 'Total Distance:   0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 7, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 7, 2, 'Turn RIGHT onto E CAMELBACK RD.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 7, 3, 'Total Distance:  0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 8, 1, 'Start out going North on N 22ND ST towards E CAMELBACK RD by turning right.  0.1 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 8, 2, 'Turn RIGHT onto E CAMELBACK RD.   0.4 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 8, 3, 'Turn RIGHT onto N 24TH ST.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 8, 4, 'Turn LEFT onto E THOMAS RD.   0.4 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 8, 5, 'Total Distance:  1.3 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 9, 1, 'Start out going South on N 22ND ST towards E HIGHLAND AVE by turning left.  1.0 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 9, 2, 'Turn LEFT onto E INDIAN SCHOOL RD.   0.5 miles');
INSERT INTO  directions (rest_id, step_id, step_text) values ( 9, 3, 'Total Distance:  1.6 miles');

